<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Aspiration;
use App\Models\Document;

class DashboardController extends Controller
{
    public function index()
    {
        $data = [
            'news_count' => News::count(),
            'aspirations_pending' => Aspiration::where('status', 'pending')->count(),
            'documents_count' => Document::count(),
            'recent_aspirations' => Aspiration::orderBy('created_at', 'desc')->take(5)->get(),
        ];

        return view('admin.dashboard', $data);
    }
}