<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use App\Models\News;
use App\Models\Program;
use App\Models\Structure;
use App\Models\Document;
use App\Models\Aspiration;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $sliders = Slider::active()->ordered()->get();
        $news = News::published()->orderBy('published_at', 'desc')->take(6)->get();
        $programs = Program::active()->take(6)->get();

        return view('frontend.home', compact('sliders', 'news', 'programs'));
    }

    public function about()
    {
        return view('frontend.about');
    }

    public function news()
    {
        $news = News::published()->orderBy('published_at', 'desc')->paginate(9);
        return view('frontend.news', compact('news'));
    }

    public function newsDetail($slug)
    {
        $news = News::where('slug', $slug)->published()->firstOrFail();

        $relatedNews = News::published()
            ->category($news->category)
            ->where('id', '!=', $news->id)
            ->take(3)
            ->get();

        return view('frontend.news-detail', compact('news', 'relatedNews'));
    }

    public function programs()
    {
        $programs = Program::active()->get();
        return view('frontend.programs', compact('programs'));
    }

    public function structure()
    {
        $structures = Structure::ordered()->get();
        return view('frontend.structure', compact('structures'));
    }

    public function documents()
    {
        $documents = Document::orderBy('created_at', 'desc')->paginate(10);
        return view('frontend.documents', compact('documents'));
    }

    public function aspiration()
    {
        return view('frontend.aspiration');
    }

    public function aspirationStore(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255',
            'nim' => 'nullable|max:50',
            'email' => 'required|email',
            'subject' => 'required|max:255',
            'message' => 'required',
        ]);

        Aspiration::create($request->all());

        return redirect()->route('aspiration')->with('success', 'Aspirasi Anda berhasil dikirim!');
    }

    public function contact()
    {
        return view('frontend.contact');
    }
}