<?php

namespace App\Mail;

use App\Models\Aspiration;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AspirationSubmitted extends Mailable
{
    use Queueable, SerializesModels;

    public $aspiration;

    public function __construct(Aspiration $aspiration)
    {
        $this->aspiration = $aspiration;
    }

    public function build()
    {
        return $this->subject('Konfirmasi Pengiriman Aspirasi')
            ->view('emails.aspiration_submitted');
    }
}
