<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Structure extends Model
{
    use HasFactory;

    protected $table = 'structures';

    protected $fillable = [
        'name',
        'position',
        'department',
        'photo',
        'order'
    ];

    protected $casts = [
        'order' => 'integer',
    ];

    /**
     * Scope untuk ordering
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order', 'asc');
    }

    /**
     * Accessor untuk nama lengkap dengan posisi
     */
    public function getFullNameAttribute()
    {
        return "{$this->name} - {$this->position}";
    }
}