<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class AspirasiMasukNotification extends Notification
{
    use Queueable;

    protected $aspirasi;

    public function __construct($aspirasi)
    {
        $this->aspirasi = $aspirasi;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toDatabase($notifiable)
    {
        return [
            'type' => 'aspirasi',
            'title' => 'Aspirasi Baru Masuk',
            'message' => 'Dari: ' . $this->aspirasi->name,
            'aspirasi_id' => $this->aspirasi->id,
        ];
    }
}
