<!-- resources/views/admin/news/edit.blade.php -->
@extends('layouts.admin')

@section('page-title', 'Edit Berita')

@section('content')
    <div class="bg-white rounded-lg shadow p-6 max-w-4xl">
        <form action="{{ route('admin.news.update', $news->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Judul Berita</label>
                <input type="text" name="title" value="{{ old('title', $news->title) }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Kategori</label>
                <select name="category"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
                    <option value="umum" {{ $news->category == 'umum' ? 'selected' : '' }}>Umum</option>
                    <option value="kegiatan" {{ $news->category == 'kegiatan' ? 'selected' : '' }}>Kegiatan</option>
                    <option value="pengumuman" {{ $news->category == 'pengumuman' ? 'selected' : '' }}>Pengumuman</option>
                    <option value="aspirasi" {{ $news->category == 'aspirasi' ? 'selected' : '' }}>Aspirasi</option>
                </select>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Gambar</label>
                @if($news->image)
                    <img src="{{ Storage::url($news->image) }}" alt="{{ $news->title }}"
                        class="w-48 h-32 object-cover rounded mb-2">
                @endif
                <input type="file" name="image" accept="image/*" class="w-full px-4 py-2 border rounded-lg">
                <p class="text-sm text-gray-500 mt-1">Kosongkan jika tidak ingin mengubah gambar</p>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Konten</label>
                <textarea name="content" rows="10"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>{{ old('content', $news->content) }}</textarea>
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="checkbox" name="is_published" value="1" {{ $news->is_published ? 'checked' : '' }}
                        class="mr-2">
                    <span class="text-gray-700">Publikasikan berita</span>
                </label>
            </div>

            <div class="flex space-x-4">
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                    <i class="fas fa-save mr-2"></i> Update
                </button>
                <a href="{{ route('admin.news.index') }}"
                    class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                    Batal
                </a>
            </div>
        </form>
    </div>
@endsection