<!-- 
=======================================================
FILE 3: resources/views/admin/structures/edit.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('struktur', 'Edit Struktur')

@section('content')
    <div class="bg-white rounded-lg shadow p-6 max-w-2xl">
        <form action="{{ route('admin.structures.update', $structure->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Nama Lengkap</label>
                <input type="text" name="name" value="{{ old('name', $structure->name) }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Jabatan</label>
                <input type="text" name="position" value="{{ old('position', $structure->position) }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Jurusan (Opsional)</label>
                <input type="text" name="department" value="{{ old('department', $structure->department) }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600">
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Foto</label>
                @if($structure->photo)
                    <img src="{{ Storage::url($structure->photo) }}" class="w-32 h-32 object-cover rounded mb-2">
                @endif
                <input type="file" name="photo" accept="image/*" class="w-full px-4 py-2 border rounded-lg">
                <p class="text-sm text-gray-500 mt-1">Kosongkan jika tidak ingin mengubah foto</p>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Urutan</label>
                <input type="number" name="order" value="{{ old('order', $structure->order) }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600">
            </div>

            <div class="flex space-x-4">
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                    <i class="fas fa-save mr-2"></i> Update
                </button>
                <a href="{{ route('admin.structures.index') }}"
                    class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                    Batal
                </a>
            </div>
        </form>
    </div>
@endsection