<!-- 
=====================================================
FILE 4: resources/views/frontend/news-detail.blade.php
=====================================================
-->
@extends('layouts.frontend')

@section('title', $news->title)

@section('content')
<div class="bg-gray-100 py-8">
    <div class="container mx-auto px-4">
        <nav class="text-gray-600 mb-4">
            <a href="{{ route('home') }}" class="hover:text-purple-600">Beranda</a>
            <span class="mx-2">/</span>
            <a href="{{ route('news') }}" class="hover:text-purple-600">Berita</a>
            <span class="mx-2">/</span>
            <span class="text-gray-800">{{ Str::limit($news->title, 50) }}</span>
        </nav>
    </div>
</div>

<section class="py-16">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <article class="bg-white rounded-xl shadow-lg overflow-hidden">
                @if($news->image)
                <img src="{{ Storage::url($news->image) }}" alt="{{ $news->title }}" class="w-full h-96 object-cover">
                @endif
                
                <div class="p-8">
                    <div class="mb-4">
                        <span class="inline-block bg-purple-100 text-purple-800 px-4 py-2 rounded-full text-sm font-semibold">
                            {{ ucfirst($news->category) }}
                        </span>
                    </div>
                    
                    <h1 class="text-4xl font-bold text-gray-800 mb-4">{{ $news->title }}</h1>
                    
                    <div class="flex items-center text-gray-600 mb-8 pb-8 border-b border-gray-200">
                        <i class="fas fa-calendar-alt mr-2"></i>
                        <span>{{ $news->published_at->format('d F Y') }}</span>
                    </div>
                    
                    <div class="prose max-w-none text-gray-700 leading-relaxed text-lg">
                        {!! nl2br(e($news->content)) !!}
                    </div>
                </div>
            </article>

            @if($relatedNews->count() > 0)
            <div class="mt-16">
                <h2 class="text-3xl font-bold text-gray-800 mb-8">Berita Terkait</h2>
                <div class="grid md:grid-cols-3 gap-6">
                    @foreach($relatedNews as $related)
                    <a href="{{ route('news.detail', $related->slug) }}" class="block bg-white rounded-lg shadow overflow-hidden card-hover">
                        @if($related->image)
                        <img src="{{ Storage::url($related->image) }}" alt="{{ $related->title }}" class="w-full h-40 object-cover">
                        @else
                        <div class="w-full h-40 bg-gradient-to-br from-purple-400 to-purple-600"></div>
                        @endif
                        <div class="p-4">
                            <h3 class="text-lg font-bold text-gray-800 mb-2">{{ Str::limit($related->title, 50) }}</h3>
                            <p class="text-gray-500 text-sm">{{ $related->published_at->format('d M Y') }}</p>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</section>
@endsection
