@extends('layouts.frontend')

@section('title', 'Program Kerja DPM')

@section('content')
    <div class="hero-gradient text-white py-20" style="
            background-image: url('{{ asset('img/DPM.jpg') }}');
            background-size: cover;
            background-position: center;
            background-color: rgba(0, 0, 0, 0.7);
            background-blend-mode: overlay;
            background-repeat: no-repeat;">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-bold mb-4">Program Kerja DPM</h1>
            <p class="text-xl">Program dan kegiatan untuk kemajuan mahasiswa</p>
        </div>
    </div>

    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-2 gap-8">
                @forelse($programs as $program)
                    <div class="bg-white p-8 rounded-xl shadow-lg card-hover">
                        <div class="flex items-start space-x-4">
                            <div class="w-16 h-16 bg-purple-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-tasks text-purple-600 text-2xl"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-2xl font-bold text-gray-800 mb-3">{{ $program->name }}</h3>
                                <p class="text-gray-600 leading-relaxed">{{ $program->description }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="col-span-2 text-center py-16">
                        <i class="fas fa-tasks text-6xl text-gray-300 mb-4"></i>
                        <p class="text-gray-500 text-xl">Belum ada program kerja tersedia</p>
                        <p class="text-gray-400 mt-2">Program kerja akan segera ditambahkan</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>
@endsection