<!-- 
=======================================================
FILE: resources/views/layouts/frontend.blade.php
=======================================================
PERBAIKAN: Pastikan Tailwind CSS dan Font Awesome load dengan benar
-->
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title', 'DPM Politeknik Balekambang Jepara')</title>
    <link rel="shortcut icon" href="{{ asset('img/Logo.png') }}" type="image/x-icon">
    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Custom Styles -->
    <style>
        .hero-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }

        /* Fix untuk content yang pakai nl2br */
        .prose {
            max-width: none;
        }

        .prose p {
            margin-bottom: 1em;
        }
    </style>
</head>

<body class="bg-gray-50">

    <!-- Navbar -->
    <nav class="fixed w-full bg-white shadow-md z-50">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <!-- Logo -->
                <div class="flex items-center space-x-3">
                    <img src="{{ asset('img/Logo.jpg') }}" alt="Logo" style="width:50px;">
                    <div>
                        <h1 class="text-xl font-bold text-gray-800">DPM</h1>
                        <p class="text-xs text-gray-600">Politeknik Balekambang Jepara</p>
                    </div>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex space-x-6">
                    <a href="{{ route('home') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Beranda</a>
                    <a href="{{ route('about') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Tentang</a>
                    <a href="{{ route('news') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Berita</a>
                    <a href="{{ route('programs') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Program Kerja</a>
                    <a href="{{ route('structure') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Struktur</a>
                    <a href="{{ route('documents') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Dokumen</a>
                    <a href="{{ route('aspiration') }}"
                        class="text-gray-700 hover:text-purple-600 font-medium transition">Aspirasi</a>
                </div>

                <!-- Mobile Menu Button -->
                <button class="md:hidden text-gray-700" id="mobile-menu-btn" onclick="toggleMobileMenu()">
                    <i class="fas fa-bars text-2xl"></i>
                </button>
            </div>

            <!-- Mobile Menu -->
            <div class="hidden md:hidden pb-4" id="mobile-menu">
                <a href="{{ route('home') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Beranda</a>
                <a href="{{ route('about') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Tentang</a>
                <a href="{{ route('news') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Berita</a>
                <a href="{{ route('programs') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Program Kerja</a>
                <a href="{{ route('structure') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Struktur</a>
                <a href="{{ route('documents') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Dokumen</a>
                <a href="{{ route('aspiration') }}"
                    class="block py-2 text-gray-700 hover:text-purple-600 transition">Aspirasi</a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="pt-16">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white mt-16">
        <div class="container mx-auto px-4 py-12">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-bold mb-4">DPM Politeknik Balekambang</h3>
                    <p class="text-gray-400">Dewan Perwakilan Mahasiswa Politeknik Balekambang Jepara</p>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4">Kontak</h4>
                    <p class="text-gray-400"><i class="fas fa-map-marker-alt mr-2"></i>Jepara, Jawa Tengah</p>
                    <p class="text-gray-400"><i class="fas fa-envelope mr-2"></i>dpmpolibang@gmail.com</p>
                    <p class="text-gray-400"><i class="fas fa-phone mr-2"></i>085648037418</p>
                </div>
                <div>
                    <h4 class="text-lg font-semibold mb-4">Media Sosial</h4>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white transition"><i
                                class="fab fa-facebook text-2xl"></i></a>
                        <a href="https://www.instagram.com/dpm.polibang?igsh=c3M5NmZiMGZtZm85"
                            class="text-gray-400 hover:text-white transition"><i
                                class="fab fa-instagram text-2xl"></i></a>
                        <a href="#" class="text-gray-400 hover:text-white transition"><i
                                class="fab fa-twitter text-2xl"></i></a>
                        <a href="" class="text-gray-400 hover:text-white transition"><i
                                class="fab fa-whatsapp text-2xl"></i></a>
                    </div>
                </div>
            </div>
            <div class="border-t border-gray-800 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; 2026 DPM Politeknik Balekambang Jepara. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        }
    </script>

</body>

</html>