<!-- 
=======================================================
FILE 4: resources/views/admin/aspirations/show.blade.php
=======================================================
-->


<?php $__env->startSection('aspirasi', 'Detail Aspirasi'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl">
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Nama</h3>
                    <p class="text-lg font-semibold"><?php echo e($aspiration->name); ?></p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">NIM</h3>
                    <p class="text-lg"><?php echo e($aspiration->nim ?? '-'); ?></p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Email</h3>
                    <p class="text-lg"><?php echo e($aspiration->email); ?></p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Tanggal</h3>
                    <p class="text-lg"><?php echo e($aspiration->created_at->format('d F Y H:i')); ?></p>
                </div>
            </div>

            <div class="border-t pt-6">
                <h3 class="text-sm text-gray-500 mb-1">Subjek</h3>
                <p class="text-xl font-semibold mb-4"><?php echo e($aspiration->subject); ?></p>

                <h3 class="text-sm text-gray-500 mb-1">Pesan/Aspirasi</h3>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-gray-700 leading-relaxed whitespace-pre-wrap"><?php echo e($aspiration->message); ?></p>
                </div>
            </div>
        </div>

        <!-- Form Update Status & Response -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Update Status & Respon</h3>

            <form action="<?php echo e(route('admin.aspirations.update', $aspiration->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">Status</label>
                    <select name="status"
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                        required>
                        <option value="pending" <?php echo e($aspiration->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="process" <?php echo e($aspiration->status == 'process' ? 'selected' : ''); ?>>Diproses</option>
                        <option value="done" <?php echo e($aspiration->status == 'done' ? 'selected' : ''); ?>>Selesai</option>
                    </select>
                </div>

                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">Respon/Tindak Lanjut</label>
                    <textarea name="response" rows="5"
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"><?php echo e(old('response', $aspiration->response)); ?></textarea>
                    <p class="text-sm text-gray-500 mt-1">Berikan tanggapan atau tindak lanjut untuk aspirasi ini</p>
                </div>

                <div class="flex space-x-4">
                    <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                        <i class="fas fa-save mr-2"></i> Update
                    </button>
                    <a href="<?php echo e(route('admin.aspirations.index')); ?>"
                        class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                        Kembali
                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\aspirations\show.blade.php ENDPATH**/ ?>