<!-- 
=======================================================
FILE 3: resources/views/admin/sliders/edit.blade.php
=======================================================
-->


<?php $__env->startSection('page-title', 'Edit Slider'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-lg shadow p-6 max-w-2xl">
        <form action="<?php echo e(route('admin.sliders.update', $slider->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Judul</label>
                <input type="text" name="title" value="<?php echo e(old('title', $slider->title)); ?>"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Deskripsi</label>
                <textarea name="description" rows="3"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"><?php echo e(old('description', $slider->description)); ?></textarea>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Gambar Slider</label>
                <?php if($slider->image): ?>
                    <img src="<?php echo e(Storage::url($slider->image)); ?>" class="w-48 h-32 object-cover rounded mb-2">
                <?php endif; ?>
                <input type="file" name="image" accept="image/*" class="w-full px-4 py-2 border rounded-lg">
                <p class="text-sm text-gray-500 mt-1">Kosongkan jika tidak ingin mengubah gambar</p>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Urutan</label>
                <input type="number" name="order" value="<?php echo e(old('order', $slider->order)); ?>"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600">
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" <?php echo e($slider->is_active ? 'checked' : ''); ?>

                        class="mr-2">
                    <span class="text-gray-700">Aktifkan slider</span>
                </label>
            </div>

            <div class="flex space-x-4">
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                    <i class="fas fa-save mr-2"></i> Update
                </button>
                <a href="<?php echo e(route('admin.sliders.index')); ?>"
                    class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                    Batal
                </a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\sliders\edit.blade.php ENDPATH**/ ?>