

<?php $__env->startSection('page-title', 'Kelola Aspirasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6 flex flex-wrap justify-between items-center gap-4">
    <!-- Filter Status -->
    <div class="flex flex-wrap gap-2">
        <a href="<?php echo e(route('admin.aspirations.index')); ?>" 
           class="px-4 py-2 rounded-lg <?php echo e(!request('status') ? 'bg-purple-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'); ?>">
            Semua
        </a>
        <a href="<?php echo e(route('admin.aspirations.index', ['status' => 'pending'])); ?>" 
           class="px-4 py-2 rounded-lg <?php echo e(request('status') == 'pending' ? 'bg-yellow-500 text-white' : 'bg-yellow-100 text-yellow-800 hover:bg-yellow-200'); ?>">
            Pending
        </a>
        <a href="<?php echo e(route('admin.aspirations.index', ['status' => 'process'])); ?>" 
           class="px-4 py-2 rounded-lg <?php echo e(request('status') == 'process' ? 'bg-blue-500 text-white' : 'bg-blue-100 text-blue-800 hover:bg-blue-200'); ?>">
            Proses
        </a>
        <a href="<?php echo e(route('admin.aspirations.index', ['status' => 'done'])); ?>" 
           class="px-4 py-2 rounded-lg <?php echo e(request('status') == 'done' ? 'bg-green-500 text-white' : 'bg-green-100 text-green-800 hover:bg-green-200'); ?>">
            Selesai
        </a>
    </div>
    
    <!-- Tombol Export Excel -->
    <div class="flex gap-2">
        <a href="<?php echo e(route('admin.aspirations.export', ['status' => request('status')])); ?>" 
           class="inline-flex items-center px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition">
            <i class="fas fa-file-excel mr-2"></i>
            Export Excel
        </a>
    </div>
</div>

<div class="bg-white rounded-lg shadow overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">No</th>
                    <th class="px-6 py-4">Nama</th>
                    <th class="px-6 py-4">NIM</th>
                    <th class="px-6 py-4">Subjek</th>
                    <th class="px-6 py-4">Tanggal</th>
                    <th class="px-6 py-4">Status</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $aspirations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $aspiration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-t hover:bg-gray-50">
                    <td class="px-6 py-4"><?php echo e($aspirations->firstItem() + $index); ?></td>
                    <td class="px-6 py-4 font-semibold"><?php echo e($aspiration->name); ?></td>
                    <td class="px-6 py-4"><?php echo e($aspiration->nim ?? '-'); ?></td>
                    <td class="px-6 py-4"><?php echo e(Str::limit($aspiration->subject, 40)); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($aspiration->created_at->format('d M Y H:i')); ?></td>
                    <td class="px-6 py-4">
                        <?php if($aspiration->status == 'pending'): ?>
                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 text-xs rounded">Pending</span>
                        <?php elseif($aspiration->status == 'process'): ?>
                        <span class="px-2 py-1 bg-blue-100 text-blue-800 text-xs rounded">Proses</span>
                        <?php else: ?>
                        <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded">Selesai</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4">
                        <a href="<?php echo e(route('admin.aspirations.show', $aspiration->id)); ?>" 
                           class="text-blue-600 hover:text-blue-800 mr-3">
                            <i class="fas fa-eye"></i> Detail
                        </a>
                        <form action="<?php echo e(route('admin.aspirations.destroy', $aspiration->id)); ?>" 
                              method="POST" class="inline" 
                              onsubmit="return confirm('Yakin ingin menghapus?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-800">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-8 text-center text-gray-500">
                        Belum ada aspirasi
                        <?php if(request('status')): ?>
                            dengan status <strong><?php echo e(ucfirst(request('status'))); ?></strong>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php if($aspirations->hasPages()): ?>
<div class="mt-6">
    <?php echo e($aspirations->appends(request()->query())->links()); ?>

</div>
<?php endif; ?>

<!-- Info Box -->
<div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
    <div class="flex items-start">
        <i class="fas fa-info-circle text-blue-600 text-xl mr-3 mt-1"></i>
        <div>
            <p class="text-blue-900 font-semibold mb-1">Tentang Export Excel</p>
            <ul class="text-blue-800 text-sm space-y-1">
                <li>• File Excel akan berisi semua data aspirasi sesuai filter yang dipilih</li>
                <li>• Format: Nama, NIM, Email, Subjek, Pesan, Status, Respon, Tanggal</li>
                <li>• File akan terdownload otomatis ke folder Download Anda</li>
            </ul>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\aspirations\index.blade.php ENDPATH**/ ?>