<!-- 
=======================================================
FILE 6: resources/views/admin/programs/edit.blade.php
=======================================================
-->


<?php $__env->startSection('program', 'Edit Program'); ?>

<?php $__env->startSection('content'); ?>
    <div class="bg-white rounded-lg shadow p-6 max-w-2xl">
        <form action="<?php echo e(route('admin.programs.update', $program->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Nama Program</label>
                <input type="text" name="name" value="<?php echo e(old('name', $program->name)); ?>"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Deskripsi</label>
                <textarea name="description" rows="5"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required><?php echo e(old('description', $program->description)); ?></textarea>
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" <?php echo e($program->is_active ? 'checked' : ''); ?>

                        class="mr-2">
                    <span class="text-gray-700">Aktifkan program</span>
                </label>
            </div>

            <div class="flex space-x-4">
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                    <i class="fas fa-save mr-2"></i> Update
                </button>
                <a href="<?php echo e(route('admin.programs.index')); ?>"
                    class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                    Batal
                </a>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\programs\edit.blade.php ENDPATH**/ ?>