

<?php $__env->startSection('title', 'Berita DPM'); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-gradient text-white py-20"style="
                                                    background-image: url('<?php echo e(asset('img/politeknik.jpg')); ?>');
                                                    background-size: cover;
                                                    background-position: center;
                                                    background-repeat: no-repeat;
                                                    background-color: rgba(0, 0, 0, 0.5);
                                                    background-blend-mode: overlay;">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-bold mb-4">Berita DPM</h1>
            <p class="text-xl">Informasi dan kegiatan terkini</p>
        </div>
    </div>

    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-3 gap-8">
                <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="<?php echo e(route('news.detail', $item->slug)); ?>"
                        class="block bg-white rounded-xl shadow-lg overflow-hidden card-hover">
                        <?php if($item->image): ?>
                            <img src="<?php echo e(Storage::url($item->image)); ?>" alt="<?php echo e($item->title); ?>" class="w-full h-48 object-cover">
                        <?php else: ?>
                            <div
                                class="w-full h-48 bg-gradient-to-br from-purple-400 to-purple-600 flex items-center justify-center">
                                <i class="fas fa-newspaper text-white text-4xl"></i>
                            </div>
                        <?php endif; ?>
                        <div class="p-6">
                            <span
                                class="inline-block bg-purple-100 text-purple-800 px-3 py-1 rounded-full text-xs font-semibold mb-3">
                                <?php echo e(ucfirst($item->category)); ?>

                            </span>
                            <h3 class="text-xl font-bold text-gray-800 mb-3"><?php echo e($item->title); ?></h3>
                            <p class="text-gray-600 mb-3"><?php echo e(Str::limit(strip_tags($item->content), 100)); ?></p>
                            <div class="flex items-center text-gray-500 text-sm">
                                <i class="fas fa-calendar-alt mr-2"></i>
                                <span><?php echo e($item->published_at->format('d F Y')); ?></span>
                            </div>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-span-3 text-center py-16">
                        <i class="fas fa-newspaper text-6xl text-gray-300 mb-4"></i>
                        <p class="text-gray-500 text-xl">Belum ada berita tersedia</p>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($news->hasPages()): ?>
                <div class="mt-12">
                    <?php echo e($news->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\frontend\news.blade.php ENDPATH**/ ?>